******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for TS2PCIE412
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2008, (C) COPYRIGHT 2008, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'ts2pcie412.inc'
X__TS2PCIE412 GND A0 A1 GND VCC A2 A3 VCC SEL GND A4 A5 VCC GND A6 A7 GND VCC
+ GND VCC GND X_7B2 X_6B2 X_5B2 X_4B2 X_7B1 X_6B1 X_5B1 X_4B1 VCC X_3B2 X_2B2
+ X_1B2 X_0B2 X_3B1 X_2B1 X_1B1 X_0B1 GND VCC GND VCC TS2PCIE412
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+5u' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 SEL GND PULSE 0 'PVCC' 2.5u 2ns 2ns 998ns 2us


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VP0 A0 GND PULSE 0 'PVCC' 3u 2ns 2ns 8ns 20ns

* CHANGE TO THE OUTPUT NODE
VDATA X_0B1 DATA DC 0
RLOAD DATA GND 500
R0B2 X_0B2 0 500

* VOLTAGE SUPPLIES

.param PVCC=1.8
.param PGND=0v
VVCC VCC 0 PWL 0 0 100n 'PVCC' 5u 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 GND 0 1G
* R1G_2 A0 0 1G
R1G_3 A1 0 1G
* R1G_4 GND 0 1G
* R1G_5 VCC 0 1G
R1G_6 A2 0 1G
R1G_7 A3 0 1G
* R1G_8 VCC 0 1G
* R1G_9 SEL 0 1G
* R1G_10 GND 0 1G
R1G_11 A4 0 1G
R1G_12 A5 0 1G
* R1G_13 VCC 0 1G
* R1G_14 GND 0 1G
R1G_15 A6 0 1G
R1G_16 A7 0 1G
* R1G_17 GND 0 1G
* R1G_18 VCC 0 1G
* R1G_19 GND 0 1G
* R1G_20 VCC 0 1G
* R1G_21 GND 0 1G
R1G_22 X_7B2 0 1G
R1G_23 X_6B2 0 1G
R1G_24 X_5B2 0 1G
R1G_25 X_4B2 0 1G
R1G_26 X_7B1 0 1G
R1G_27 X_6B1 0 1G
R1G_28 X_5B1 0 1G
R1G_29 X_4B1 0 1G
* R1G_30 VCC 0 1G
R1G_31 X_3B2 0 1G
R1G_32 X_2B2 0 1G
R1G_33 X_1B2 0 1G
*R1G_34 X_0B2 0 1G
R1G_35 X_3B1 0 1G
R1G_36 X_2B1 0 1G
R1G_37 X_1B1 0 1G
* R1G_38 X_0B1 0 1G
* R1G_39 GND 0 1G
* R1G_40 VCC 0 1G
* R1G_41 GND 0 1G
* R1G_42 VCC 0 1G

.END
