* BEGIN MODEL LMP2022
* Rev. B, November, 2008
*//////////////////////////////////////////////////////////////////////
* (C) National Semiconductor, Corporation.
* Models developed and under copyright by:
* National Semiconductor, Corporation.  
*/////////////////////////////////////////////////////////////////////
* Legal Notice:  
* The model may be copied, and distributed without any modifications;
* however, reselling or licensing the material is illegal.
* We reserve the right to make changes to the model without prior notice. 
* Pspice Models are provided "AS IS, WITH NO WARRANTY OF ANY KIND" 
*////////////////////////////////////////////////////////////////////
*
* NOTE - THIS MODEL REQUIRES THE USER TO SET UP FOUR COMPONENTS FOR
* THE DESIRED POSITIVE INPUT BIAS CURRENT, NEGATIVE INPUT BIAS CURRENT,
* INPUT REFERRED VOLTAGE NOISE, AND INPUT OFFSET VOLTAGE. PLEASE SEE
* THE COMMENTS BELOW AND THE DATA SHEET IN ORDER TO DETERMINE THE BEST
* VALUES FOR THESE FOUR COMPONENTS IN ANY GIVEN APPLICATION.
*//////////////////////////////////////////////////////////////////////
*
* PINOUT ORDER +IN -IN +V -V OUT
* PINOUT ORDER  4   3   5  2  1
.SUBCKT LMP2022 4 3 5 2 1
*
*////////////////////////////////////////////////////////////////
* MODEL FEATURES INCLUDE OUTPUT SWING, OUTPUT CURRENT THRU
* THE SUPPLY RAILS, OUTPUT CURRENT LIMIT, OPEN LOOP GAIN
* VERSUS FREQUENCY, SLEW RATE, COMMON MODE REJECTION WITH
* FREQ EFFECTS, POWER SUPPLY REJECTION WITH FREQ EFFECTS,
* INPUT VOLTAGE NOISE, INPUT CURRENT NOISE, INPUT BIAS
* CURRENT, INPUT COMMON MODE RANGE, INPUT OFFSET VOLTAGE
* WITH TEMPERATURE EFFECTS, AND QUIESCENT CURRENT for a 
* SINGLE AMPLIFIER VS VOLTAGE AND TEMPERATURE. NOTE THAT 
* MODEL ONLY GIVES APPROXIMATE OPEN LOOP PHASE VERSUS 
* FREQUENCY BUT IS STABLE AT ALL GAINS 1 TO 10000. INPUT
* BIAS CURRENT VARIATION WITH VCM IN THE MODEL IS NOT
* REPRESENTATIVE OF ACTUAL DEVICE OPERATION; VALUE OF BIAS
* CURRENT SHOULD BE SET BELOW
*
***NOTE THAT SUPPLY CURRENT MODELED IS FOR A SINGLE AMPLIFIER ONLY***
*
*//////////////////////////////////////////////////////////
*
* BEGIN USER PROGRAMMING
*
* INPUT BIAS CURRENTS
* FOR MORE ACCURACY AT LOW BIAS CURRENTS CHANGE THE
* SPICE SIMULATION PARAMETER GMIN FROM ITS DEFAULT
* VALUE OF 1E-12 TO 1E-13
* V145 IS FOR THE POS INPUT AND V148 FOR NEG INPUT
* SCALING IS 10 PA PER VOLT DEFAULT IS 2.5 V = 25 PA
V145 70 0 2.5
V148 71 0 2.5
***************************************************
* INPUT REFERRED VOLTAGE NOISE
* SET E15 TO THE NOISE LEVEL INDICATED ON THE NOISE VS
* GAIN GRAPH IN DATASHEET
* E15 for en IN THE RANGE OF 11 TO 18 NV / ROOT HERTZ
* E15  NV/RHZ          E15  NV/RHZ          E15  NV/RHZ
* 0.3  = 11            0.4 = 11.3           0.5 = 11.6
* 0.6  = 12            0.7 = 12.4           0.8 = 12.9
* 0.9  = 13.4          1.0 = 14             1.1 = 14.6
* 1.2  = 15.3          1.3 = 15.9           1.4 = 16.6
* 1.5  = 17.3          1.6 = 18
* DEFAULT IS 11 NV/RHZ
E15 8 3 9 0 0.3
********************************************
* INPUT OFFSET VOLTAGE
* V139 SETS THE RELATIVE OFFSET VOLTAGE
* OFFSET VOLTAGE IS DEFAULTED FOR -0.4 UV
* AND MAY BE ADJUSTED UP AND DOWN LINEARLY
* BY MOVING V139 DEFAULT -5.31U UP OR DOWN
V139 10 25 -5.31U
* END USER PROGRAMMING
*//////////////////////////////////////////////////
D17 6 0 DIN
D18 7 0 DIN
I14 0 6 0.1E-3
I15 0 7 0.1E-3
G5 10 8 6 7 3E-14
E16 11 0 12 0 1
E17 13 0 14 0 1
E18 15 0 16 0 1
R56 11 17 1E6
R57 13 18 1E6
R58 15 19 1E6
R59 0 17 10
R60 0 18 10
R61 0 19 10
E19 20 21 19 0 -0.004
R62 22 16 1E3
R63 16 23 1E3
C15 11 17 1E-12
C16 13 18 1E-12
C17 15 19 1E-12
E20 24 20 18 0 -0.1
E21 25 24 17 0 0.1
R64 0 26 1E12
V52 26 0 1
G12 10 8 27 0 3.84E-5
R136 0 27 1E4
R137 0 27 1E4
R138 21 20 1E9
R139 20 24 1E9
R140 24 25 1E9
E54 23 0 10 0 1
E55 22 0 8 0 1
C23 10 8 0.25E-12
E57 21 4 28 0 2.25E-6
R146 21 4 1E9
R147 0 26 1E12
Q41 29 30 14 QLN
R148 30 31 1E3
R149 32 33 1E3
R150 34 12 1.7
R151 14 35 1.7
R153 36 37 1500
R154 38 12 1.7
R155 14 39 1.7
D22 40 5 DD
D23 2 40 DD
E58 14 0 2 0 1
E59 12 0 5 0 1
R156 2 5 4E4
E60 41 14 12 14 0.5
D24 36 12 DD
D25 14 36 DD
R157 42 43 100
R158 44 45 100
G14 36 41 46 41 0.5E-4
R159 41 36 35E9
C24 37 47 4E-12
C25 40 0 1E-12
D26 45 29 DD
D27 48 43 DD
Q42 48 33 12 QLP
R160 40 49 1
R161 50 40 1
E61 51 41 52 53 -1
R162 51 46 1E4
C26 46 41 0.025E-12
G15 54 41 36 41 -1E-3
G16 41 55 36 41 1E-3
G17 41 56 57 14 1E-3
G18 58 41 12 59 1E-3
D28 58 54 DD
D29 55 56 DD
R163 54 58 100E6
R164 56 55 100E6
R165 58 12 1E3
R166 14 56 1E3
R167 55 41 1E6
R168 56 41 1E6
R169 41 58 1E6
R170 41 54 1E6
G19 5 2 26 0 0.8E-13
R171 41 46 1E9
R172 42 12 1E9
R173 14 44 1E9
G20 59 57 26 0 0.1E-3
I22 5 2 0.723E-3
L2 40 1 3E-9
R175 40 1 1E3
R176 59 12 1E8
R177 14 57 1E8
R178 35 45 1E8
R179 34 43 1E8
R180 0 26 1E9
E99 12 32 5 34 9
E100 31 14 35 2 9
E124 47 0 40 0 1
R719 36 47 7E11
I30 0 60 1E-3
D46 60 0 DD
R778 0 60 10E6
V127 60 28 0.65
R779 0 28 10E6
Q52 49 43 34 QLP
Q53 50 45 35 QLN
Q54 57 57 39 QLN
Q55 59 59 38 QLP
E144 12 42 12 58 1
E145 44 14 56 14 1
G23 5 0 49 40 1
G24 2 0 40 50 -1
G25 5 2 28 0 -1.3E-3
R792 61 62 1
R793 61 63 1
R794 52 12 1E4
R795 53 12 1E4
M8 52 10 62 62 NIN L=2U W=50U
M9 53 8 63 63 NIN L=2U W=50U
C106 10 0 12E-12
C107 8 0 12E-12
R796 0 9 1E4
R797 0 9 1E4
V141 12 64 1.26
M10 61 65 66 66 NIN L=2U W=50U
M11 65 65 66 66 NIN L=2U W=50U
V142 66 14 -0.7
J1 64 10 64 JC
J2 64 8 64 JC
I36 0 67 1E-3
D51 67 0 DD
V144 67 68 1.655
E153 69 0 68 0 -1
R800 0 68 1E9
G26 12 65 69 0 21.6E-6
G27 10 0 70 0 1E-11
G28 8 0 71 0 1E-11
R801 0 70 1E9
R803 0 71 1E9
R804 0 69 1E9
R805 3 8 1E9
.MODEL JC NJF IS=1E-22
.MODEL DD D
.MODEL DVN D KF=2.5E-15
.MODEL DIN D KF=8E-15
.MODEL QLN NPN
.MODEL QLP PNP
.MODEL NIN NMOS KP=200U VTO=0.5 IS=1E-18
.ENDS
* END MODEL LMP2022
