*//////////////////////////////////////////////////////////////////////
* (C) National Semiconductor, Corporation.
* Models developed and under copyright by:
* National Semiconductor, Corporation.  
*/////////////////////////////////////////////////////////////////////
* Legal Notice:  
* The model may be copied, and distributed without any modifications;
* however, reselling or licensing the material is illegal.
* We reserve the right to make changes to the model without prior notice. 
* Pspice Models are provided "AS IS, WITH NO WARRANTY OF ANY KIND" 
*////////////////////////////////////////////////////////////////////
* LMP7704 SPICE MODEL PERFORMANCE
*///////////////////////////////////////////////////////////////////
* MODEL FEATURES INCLUDE OUTPUT SWING, OUTPUT CURRENT THRU
* THE SUPPLY RAILS, GAIN AND PHASE, SLEW RATE, COMMON MODE
* REJECTION WITH FREQUENCY EFFECTS, POWER SUPPLY REJECTION
* WITH FREQUENCY EFFECTS, INPUT VOLTAGE NOISE WITH 1/F,
* INPUT CURRENT NOISE WITH F^2, QUIESCENT	CURRENT AND CHANGE
* WITH SUPPLY VOLTAGE AND TEMPERATURE, INPUT OFFSET VOLTAGE
* CHANGE NEAR THE POSITIVE RAIL, INPUT BIAS CURRENT, INPUT
* BIAS CURRENT VARIANCE WITH COMMON MODE VOLTAGE INCLUDING
* A STEEPER SLOPE BEYOND THE RAILS, AND INPUT AND OUTPUT
* CLAMP DIODES.THE MODEL HAS TWO INPUT STAGES FOR 300MV
* BEYOND THE RAIL OPERATION AND A RAIL TO RAIL OUTPUT STAGE
* THAT INCLUDES BODE CHANGES WITH LOAD, CLASS AB BIAS, AND
* ABILITY TO DRIVE LARGE CLOADS.
*/////////////////////////////////////////////////////////////
*  MODEL TEMP RANGE IS -55 TO +125 DEG C.
* NOTE THAT THE MODEL IS FUNCTIONAL OVER THIS RANGE BUT NOT
* ALL PARAMETERS TRACK THOSE OF THE REAL PART.
*///////////////////////////////////////////////////////////
* Note:  Model is for single device only and simulated
*	 supply current is 1/4 of the total device current.
*///////////////////////////////////////////////////////////
* BEGIN MODEL LMP7704
* PINOUT ORDER +IN -IN +V -V OUT
* PINOUT ORDER  3   4   5  2  1
.SUBCKT LMP7701 3 4 5 2 1
* BEGIN NOTES
* BECAUSE UNDER SOME CONDITIONS THE INPUT
* BIAS CURRENT OF THIS PART IS SO LOW,
* FOR ACCURATE BIAS CURRENTS YOU MAY NEED
* TO CHANGE THE ANALYSIS PARAMETER GMIN
* FROM THE DEFAULT VALUE OF 1E-12 TO
* THE VALUE OF 3E-13 IN THE OPTIONS LINE
* END NOTES
Q21 6 7 8 QNL
R86 9 10 75
R87 11 10 75
R88 7 12 100
R89 13 14 100
R90 15 5 3.5
R91 2 16 3.5
R93 17 18 1.5E3
R94 19 20 3.5
R95 8 21 3.5
D20 1 5 DD
D21 2 1 DD
D22 22 0 DIN
D23 23 0 DIN
I20 0 22 0.1E-3
I21 0 23 0.1E-3
E27 8 0 2 0 1
E28 20 0 5 0 1
D24 24 0 DVN
D25 25 0 DVN
I22 0 24 0.2E-6
I23 0 25 0.2E-6
E29 26 4 24 25 0.06
G12 27 4 22 23 4.8E-7
R96 2 5 50E3
E30 28 0 20 0 1
E31 29 0 8 0 1
E32 30 0 31 0 1
R98 28 32 1E6
R99 29 33 1E6
R100 30 34 1E6
R101 0 32 100
R102 0 33 100
R103 0 34 100
E33 35 3 34 0 -0.0015
R104 36 31 1E3
R105 31 37 1E3
C26 28 32 0.2E-12
C27 29 33 5E-12
C28 30 34 1E-12
E34 38 35 33 0 0.2
E35 27 38 32 0 0.17
E36 39 8 20 8 0.5
D26 17 20 DD
D27 8 17 DD
M24 40 41 16 16 NOUT L=3U W=500U
M25 42 43 15 15 POUT L=3U W=500U
M26 44 44 19 19 POUT L=3U W=500U
M27 45 46 9 9 PIN L=3U W=500U
M28 47 26 11 11 PIN L=3U W=500U
M29 48 48 21 21 NOUT L=3U W=500U
R106 49 43 100
R107 50 41 100
G13 17 39 51 39 0.2E-3
R108 39 17 7E8
C29 18 1 31E-12
R109 8 45 2E3
R110 8 47 2E3
C30 45 47 5E-12
C31 27 0 25E-12
C32 26 0 25E-12
C33 1 0 1E-12
D28 41 6 DD
D29 52 43 DD
Q22 52 13 20 QPL
V26 27 46 25U
M30 53 54 55 55 NIN L=3U W=500U
R111 56 55 75
M31 57 26 58 58 NIN L=3U W=500U
R112 56 58 75
R113 53 20 2E3
R114 57 20 2E3
C34 53 57 5E-12
V27 46 54 -50U
M32 59 60 61 61 PIN L=6U W=500U
M33 62 63 20 20 PIN L=6U W=500U
V28 20 60 1.3
M34 56 59 8 8 NIN L=6U W=500U
M35 59 59 8 8 NIN L=6U W=500U
G14 17 39 64 39 0.2E-3
I24 44 48 40E-6
E37 37 0 27 0 1
E38 36 0 4 0 1
M36 63 63 20 20 PIN L=6U W=500U
I25 63 8 80E-6
V29 62 10 0
R115 1 42 7
R116 40 1 7
J5 65 27 65 JN
J6 65 26 65 JN
J7 26 66 26 JN
J8 27 66 27 JN
C35 27 26 4E-12
E39 67 39 57 53 1
R117 67 64 10E3
C36 64 39 5E-12
E40 68 39 47 45 1
R118 68 51 10E3
C37 51 39 5E-12
G15 69 39 17 39 -1E-3
G16 39 70 17 39 1E-3
G17 39 71 48 8 1E-3
G18 72 39 20 44 1E-3
D30 72 69 DD
D31 70 71 DD
R120 69 72 100E6
R121 71 70 100E6
R122 72 20 1E3
R123 8 71 1E3
E41 20 49 20 72 1
E42 50 8 71 8 1
R124 70 39 1E6
R125 71 39 1E6
R126 39 72 1E6
R127 39 69 1E6
G19 5 2 73 0 -470U
I26 0 74 1E-3
D32 74 0 DD
V31 74 73 0.71
R128 0 73 1E6
R129 38 27 1E9
R130 35 38 1E9
R131 3 35 1E9
R132 4 26 1E9
R133 39 51 1E9
R134 39 64 1E9
R135 49 20 1E9
R136 8 50 1E9
R137 31 0 1E9
R138 61 62 3K
E43 14 20 5 15 -3.1
E44 12 8 16 2 3.1
R139 17 1 5E10
V33 20 65 0.22
V34 66 8 0.22
R142 44 20 1E9
R143 8 48 1E9
D33 27 26 DC
D34 26 27 DC
I27 5 2 535E-6
R144 63 20 1E9
.MODEL JN NJF IS=1E-20
.MODEL DVN D KF=5E-16 IS=1E-16
.MODEL DIN D
.MODEL DD D
.MODEL DC D IS=1E-17 RS=10
.MODEL QNL NPN
.MODEL QPL PNP
.MODEL POUT PMOS KP=200U VTO=-0.7
.MODEL NOUT NMOS KP=200U VTO=0.7
.MODEL PIN PMOS KP=200U VTO=-0.7
.MODEL NIN NMOS KP=200U VTO=0.7
.ENDS
* END MODEL LMP7704

