/******************************************************************************
* Name: smbus.h 
* 
* Description: Definitions for SMBus constants and functions. 
* 
* Texas Instruments, Inc
* 
* Version: 1.0
******************************************************************************/

/*
 * Copyright (C) {2011} Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef SMBUS_H_
#define SMBUS_H_

// Generic Definitions
#define SMBUS_MASTER_MODE_WRITE		0x00
#define SMBUS_MASTER_MODE_READ		0x01
#define SMBUS_SLAVE_MODE_WRITE		0x02
#define SMBUS_SLAVE_MODE_READ		0x03
#define SMBUS_MSP430_ADDRESS		0x09
#define SMBUS_SLAVE_ADDRESS			0x0B
#define DESIGN_VOLTAGE_VALUE		14400			// Units (mV)

#define FLAG_SUCCESS				0
#define FLAG_FAIL					1
#define FLAG_NACK					2

#define SMBUS_PEC_PASS           0
#define SMBUS_PEC_FAIL           1
#define CRC8_POLY	   			0x07
#define CRC8_INIT_REM      		0x0

// SMBus Data Declarations
#define SMBUS_DATA_TO_SLAVE			32				// Transmit Table Length
#define SMBUS_DATA_FROM_SLAVE		32				// Receive Table Length

// SMBus Command Definitions
#define SBS_CMD_TEMPERATURE					0x08
#define SBS_CMD_VOLTAGE						0x09
#define SBS_CMD_CURRENT						0x0A
#define SBS_CMD_AVERAGE_CURRENT				0x0B
#define SBS_CMD_RELATIVE_STATE_OF_CHARGE	0x0D
#define SBS_CMD_CHARGING_CURRENT			0x14
#define SBS_CMD_CHARGING_VOLTAGE			0x15
#define SBS_CMD_BATTERY_STATUS				0x16
#define SBS_CMD_DESIGN_VOLTAGE				0x19
#define SBS_CMD_MANUFACTURER_NAME			0x20
#define SBS_CMD_DEVICE_NAME					0x21
#define SBS_CMD_CELL_VOLTAGE_4				0x3C
#define SBS_CMD_CELL_VOLTAGE_3				0x3D
#define SBS_CMD_CELL_VOLTAGE_2				0x3E
#define SBS_CMD_CELL_VOLTAGE_1				0x3F

// SBS Battery Status Register Bits
#define SBS_REG_BATTERYSTATUS_OCA		BITF		// Over Charged Alarm
#define SBS_REG_BATTERYSTATUS_TCA		BITE		// Terminate Charge Alarm
#define SBS_REG_BATTERYSTATUS_OTA		BITC		// Over Temperature Alarm
#define SBS_REG_BATTERYSTATUS_FC		BIT5		// Fully Charged

#define BUS_1						1
#define BUS_2						2

#define SMBUS_MASTER_MODE			0
#define SMBUS_SLAVE_MODE			1

#define SMBUS_START_FLAG_SET		1
#define SMBUS_START_FLAG_RESET		0

// External Global Variable Declarations
extern unsigned char SMBus_Data_To_Slave[SMBUS_DATA_TO_SLAVE];
extern unsigned char SMBus_Data_From_Slave[SMBUS_DATA_FROM_SLAVE];
extern unsigned char *pTXData;                     	// Pointer to TX data
extern unsigned char TXByteCounter;
extern unsigned char *pRXData;                     	// Pointer to RX data
extern unsigned char RXByteCounter;
extern unsigned char RXFlag;							// Data Received Flag
extern unsigned char TXFlag;							// Data Transmitted Flag
extern unsigned char RWFlag;						// Read/Write Flag
extern unsigned char SMBus_Start_Flag;

// Function Prototypes
void SMBus_Initialize(unsigned char SMBus_Mode);
unsigned char SMBus_Access(unsigned char smbus_command, unsigned char \
	read_write, unsigned char size_in_bytes);	
void SMBus_Select(unsigned char bus_num);	
unsigned char SMBus_Monitor_Slave_Broadcast(void);
unsigned char SMBus_NotReady();
void SMBus_Reset(unsigned char SMBus_Start_Flag);
static unsigned short crc8MakeBitwise(unsigned char CRC, unsigned char Poly, unsigned char *Pmsg, unsigned int Msg_Size);
unsigned char SMBus_Access_PEC(unsigned char smbus_command, unsigned char \
	read_write, unsigned char size_in_bytes);

#endif /*SMBUS_H_*/
